#!/usr/bin/python
import pylast
import sys
import getopt


##
##  Scripted by --> Thomas Thammasuckdi
##  Email       --> thomas@dudewheresmycar.org
##


API_KEY = "ad701af993794b1a6e844fa39d67b912"
API_SECRET = "5c7908210a5bcc8633633934a847c4d9"

# In order to perform a write operation you need to authenticate yourself
username      = "dummyaccount123"
password_hash = pylast.md5("somethingsimple")


def usage():
    print "Usage:"
    print "%s -a <Search Term> [-l <#>] [-s]" % (sys.argv[0])
    print "\t-a\tSearch Artist in quotations."
    print "\t-l\tReturn limit. Default = 10."
    print "\t-s\tSimilar Artist."

def arguments(vars):

       # Defining values incase nothing is inputed.
       limit  = 9
       artist = None
       similar_opt = False
       # Grabs our inputs
       try:
             (opt, args) = getopt.getopt(sys.argv[1:], 'a:l:sh', [])
       except getopt.GetoptError, e:
             print "Error with your inputs."
             sys.exit(1)
       if not len(opt):
             print "\nThere were no arguments passed in."
             usage()
             sys.exit(1)
       else:
             for o in opt:
                    (option,value) = o
                    if option == "-a":
                        artist = value

                    elif option == "-l":
                        limit = value

                    elif option == "-s":
                        similar_opt = True

                    elif option == "-h":
                        usage()

                    else:
                        usage()
       if not artist:
           usage()
       return artist, limit, similar_opt


def intWithCommas(x):
    if type(x) not in [type(0), type(0L)]:
        raise TypeError("Parameter must be an integer.")
    if x < 0:
        return '-' + intWithCommas(-x)
    result = ''
    while x >= 1000:
        x, r = divmod(x, 1000)
        result = ",%03d%s" % (r, result)
    return "%d%s" % (x, result)


#################################################################################
######### Main
#################################################################################
if __name__ == '__main__':

    artist_name, limit, similar_opt =arguments(sys.argv)

network = pylast.LastFMNetwork(api_key = API_KEY, api_secret =
    API_SECRET, username = username, password_hash = password_hash)

artist    = network.get_artist(artist_name)
toptracks = artist.get_top_tracks()


#print dir(toptracks)

if toptracks:
    print "/"*59
    print "%s %s %s" % (str( "#" ).rjust(2,' ' ),  str( "Track:" ).rjust(12, ' '), str( "Plays:" ).rjust(43, ' ') )
    print "/"*59

    for i in range(len(toptracks)):
        if i > limit:
            break
            
        song   = toptracks[i].item.get_title()
        weight = str(intWithCommas(toptracks[i][1]))
        
        #Just printing it out
        print "%s  ---> %s %s" % ( str(i+1).rjust(2,' '), song.ljust(39, ' '), weight.rjust(10, ' ') )

else:
    print "No songs returned - %s is so uncool!" % sys.argv[1]

if similar_opt:
    similar   = artist.get_similar(limit)
#    print similar.__class__
    print "/"*59
    print "Simiar Artist:"
    print "/"*59
    for j in range(len(similar)):
        print similar[j].item
